/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import jclass.cell.BaseInitialEvent;
import jclass.cell.CellData;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.InitialEvent;
import jclass.cell.editors.MultilineCellEditor;
import jclass.table3.Clip;
import jclass.table3.InputHandler;
import jclass.table3.JCCell;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.JCEnterCellEvent;
import jclass.table3.JCTraverseCellEvent;
import jclass.table3.Table;
import jclass.table3.TableCellInfo;
import jclass.table3.TextCellEditor;
import jclass.table3.TraverseInitial;

public class EditHandler
implements CellEditorListener,
Serializable,
FocusListener {
    Table table;
    CellEditor editor;
    Component editComponent;
    int editRow;
    int editColumn;
    Clip clip;
    Point origin;
    TableCellInfo cellInfo;
    CellData cellDataObject;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private boolean tableFocusRequested = false;

    public EditHandler(Table table) {
        this.table = table;
    }

    public CellEditor getCellEditor() {
        return this.editor;
    }

    public void setCellEditor(CellEditor cellEditor) {
        if (cellEditor != null) {
            this.editComponent = cellEditor.getComponent();
            if (this.editComponent != null) {
                this.editComponent.addKeyListener(this.table.inputHandler);
                this.editComponent.removeFocusListener(this);
                this.editComponent.addFocusListener(this);
            }
            cellEditor.addCellEditorListener(this);
        } else {
            if (this.editor != null) {
                this.editor.removeCellEditorListener(this);
            }
            if (this.editComponent != null) {
                this.editComponent.removeKeyListener(this.table.inputHandler);
            }
            this.editComponent = null;
        }
        this.editor = cellEditor;
        this.editRow = this.table.edit_row;
        this.editColumn = this.table.edit_column;
        this.clip = Clip.find(this.table, this.editRow, this.editColumn);
    }

    boolean traverse(int n, int n2, boolean bl, InitialEvent initialEvent, String string, boolean bl2) {
        JCCellPosition jCCellPosition;
        if (initialEvent != null && initialEvent.getKey() == 16) {
            return false;
        }
        if (this.table.span.span_list.size() > 0 && this.table.span.find(n, n2, jCCellPosition = new JCCellPosition()) != -999) {
            n = jCCellPosition.row;
            n2 = jCCellPosition.column;
        }
        int n3 = this.table.edit_row;
        int n4 = this.table.edit_column;
        if (!TraverseInitial.traverse(this.table, n, n2, bl, string)) {
            return false;
        }
        if (this.table.getPeer() == null || !this.table.isVisible()) {
            this.table.edit_row = n;
            this.table.edit_column = n2;
            return true;
        }
        Component component = this.table.getComponent(n, n2);
        if (component != null) {
            component.requestFocus();
            this.table.edit_row = n;
            this.table.edit_column = n2;
        } else {
            boolean bl3 = bl2;
            if (string == null && !bl2) {
                bl3 = false;
            }
            if (!(string == null || string.equalsIgnoreCase("POINTER") && bl2 || n3 == this.table.edit_row && n4 == this.table.edit_column)) {
                bl3 = false;
            }
            if (!this.table.getEditable(n, n2) || !this.table.dataView.getEditable()) {
                bl3 = false;
            }
            if (initialEvent == null) {
                if (bl2) {
                    this.table.clearSelectedCells();
                    initialEvent = new BaseInitialEvent(0, 0, 0);
                } else {
                    bl3 = false;
                }
            }
            if (bl3) {
                CellEditor cellEditor = this.table.dataView.getCellEditor(n, n2);
                if (this.editor != null && this.editor != cellEditor) {
                    this.cancel();
                }
                Object object = this.table.dataView.getCellData(n, n2);
                if (cellEditor instanceof TextCellEditor && object != null && (this.table.getMultiline(n, n2) || object.toString().indexOf("\n") != -1)) {
                    cellEditor = new MultilineCellEditor();
                }
                this.setCellEditor(cellEditor);
                this.cellInfo = new TableCellInfo(this.table, this.clip, n, n2);
                if (this.editor != null) {
                    Rectangle rectangle = new Rectangle();
                    JCCell.getBounds(this.table, null, n, n2, rectangle);
                    Point point = this.clip.location();
                    ((BaseInitialEvent)initialEvent).setX(initialEvent.getX() - rectangle.x - point.x);
                    ((BaseInitialEvent)initialEvent).setY(initialEvent.getY() - rectangle.y - point.y);
                    if (object instanceof CellData) {
                        this.cellDataObject = (CellData)object;
                        this.editor.initialize(initialEvent, this.cellInfo, this.cellDataObject.getData());
                    } else {
                        this.cellDataObject = null;
                        this.editor.initialize(initialEvent, this.cellInfo, object);
                    }
                    if (this.editComponent != null) {
                        Color color = this.table.getBackground(n, n2);
                        if (color instanceof SystemColor) {
                            color = new Color(((SystemColor)color).getRGB());
                        }
                        this.editComponent.hide();
                        if (this.editComponent.getParent() != this.clip) {
                            this.clip.add(this.editComponent);
                        }
                    }
                    if (this.setValues(n, n2) && this.editComponent != null) {
                        this.editComponent.show();
                        this.setFocusOnEditor(this.editComponent);
                    }
                }
            }
        }
        if ((string == null || string != null && !string.equals("PRESS")) && this.table.enterCellListeners != null) {
            JCEnterCellEvent jCEnterCellEvent = new JCEnterCellEvent(this.table, 2, n, n2, string);
            this.table.fireJCEnterCellEvent(jCEnterCellEvent);
        }
        return true;
    }

    void setFocusOnEditor(Component component) {
        if (component == null) {
            return;
        }
        if (component.isFocusTraversable()) {
            component.requestFocus();
            return;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n].isFocusTraversable()) {
                    componentArray[n].requestFocus();
                    return;
                }
                ++n;
            }
        }
    }

    boolean setValues(int n, int n2) {
        if (this.editor == null) {
            return false;
        }
        if (this.editComponent == null) {
            return true;
        }
        return this.setValues(n, n2, this.table.getEditable(n, n2) & this.table.dataView.getEditable());
    }

    boolean setValues(int n, int n2, boolean bl) {
        if (this.editor == null) {
            return false;
        }
        if (this.editComponent == null) {
            return true;
        }
        Rectangle rectangle = new Rectangle();
        JCCell.getBounds(this.table, null, n, n2, rectangle);
        if (this.table.resize_row == -999 && this.table.resize_column == -999) {
            this.editComponent.enable(this.table.isEnabled());
            this.clip.changed = false;
        }
        this.setSize(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return true;
    }

    void setSize(int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(10, 10);
        int n5 = this.table.edit_height_policy;
        int n6 = this.table.edit_width_policy;
        int n7 = Math.max(dimension.width, n3);
        int n8 = Math.max(dimension.height, n4);
        switch (n6) {
            case 1: {
                if (this.editComponent.getMinimumSize().width <= n7) break;
                n7 = this.editComponent.getMinimumSize().width;
                break;
            }
            case 2: {
                if (this.editComponent.getPreferredSize().width <= n7) break;
                n7 = this.editComponent.getPreferredSize().width;
                break;
            }
        }
        switch (n5) {
            case 1: {
                if (this.editComponent.getMinimumSize().height <= n8) break;
                n8 = this.editComponent.getMinimumSize().height;
                break;
            }
            case 2: {
                if (this.editComponent.getPreferredSize().height <= n8) break;
                n8 = this.editComponent.getPreferredSize().height;
                break;
            }
        }
        this.origin = new Point(n, n2);
        this.repositionOrigin(this.origin);
        if (this.editComponent instanceof Choice) {
            n8 = this.editComponent.getPreferredSize().height;
        }
        this.table.paint(this.editRow, this.editColumn);
        this.editComponent.setBounds(n, n2, n7, n8);
    }

    void move(int n, int n2) {
        int n3;
        int n4;
        if (this.editComponent == null) {
            return;
        }
        switch (n) {
            case 2: {
                n4 = this.editComponent.location().x;
                n3 = this.editComponent.location().y + this.clip.vert_origin - n2;
                break;
            }
            case 1: {
                n4 = this.editComponent.location().x + this.clip.horiz_origin - n2;
                n3 = this.editComponent.location().y;
                break;
            }
            default: {
                Point point = new Point(0, 0);
                this.table.getPosition(this.editRow, this.editColumn, point);
                if (point.x == Integer.MAX_VALUE) {
                    return;
                }
                n4 = point.x;
                n3 = point.y;
            }
        }
        this.origin = new Point(n4, n3);
        this.repositionOrigin(this.origin);
    }

    void repositionOrigin(Point point) {
        Dimension dimension = this.clip.size();
        Dimension dimension2 = this.editComponent.size();
        if (this.editColumn < this.table.frozen_columns) {
            if (point.x + dimension2.width > this.table.frozenColumnWidth() - this.clip.horiz_origin && dimension.width > dimension2.width) {
                point.x = this.table.frozenColumnWidth() - this.clip.horiz_origin - dimension2.width;
            }
        } else if (point.x + dimension2.width > this.table.cell_total_width - this.clip.horiz_origin && dimension.width > dimension2.width) {
            point.x = this.table.cell_total_width - this.clip.horiz_origin - dimension2.width;
        }
        if (this.editRow < this.table.frozen_rows) {
            if (point.y + dimension2.height > this.table.frozenRowHeight() - this.clip.vert_origin && dimension.height > dimension2.height) {
                point.y = this.table.frozenRowHeight() - this.clip.vert_origin - dimension2.height;
            }
        } else if (point.y + dimension2.height > this.table.cell_total_height - this.clip.vert_origin && dimension.height > dimension2.height) {
            point.y = this.table.cell_total_height - this.clip.vert_origin - dimension2.height;
        }
        this.editComponent.move(point.x, point.y);
    }

    void flash() {
        if (this.editComponent == null || !this.editComponent.isVisible()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
        if (!(this.editComponent instanceof TextComponent)) {
            return;
        }
        Color color = this.editComponent.getForeground();
        Color color2 = this.editComponent.getBackground();
        this.editComponent.setForeground(color2);
        this.editComponent.setBackground(color);
        TextComponent textComponent = null;
        String string = null;
        if (this.editComponent instanceof TextComponent && (string = (textComponent = (TextComponent)this.editComponent).getText()) != null) {
            textComponent.setText(string);
            textComponent.select(string.length(), string.length());
        }
        this.editComponent.getToolkit().sync();
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {}
        this.editComponent.setBackground(color2);
        this.editComponent.setForeground(color);
        if (this.editComponent instanceof TextComponent && string != null) {
            textComponent.setText(string);
            textComponent.select(string.length(), string.length());
        }
    }

    boolean cancel() {
        return this.cancel(true);
    }

    boolean cancel(boolean bl) {
        if (this.editor == null) {
            return true;
        }
        this.editor.cancelCellEditing();
        this.editor.removeCellEditorListener(this);
        if (bl) {
            this.removeEditor();
        }
        return true;
    }

    boolean commit() {
        return this.commit(true);
    }

    boolean commit(boolean bl) {
        return this.commit(bl, true);
    }

    boolean commit(boolean bl, boolean bl2) {
        Object object;
        if (this.editor == null) {
            return true;
        }
        if (bl2) {
            boolean bl3 = this.editor.isModified();
            if (!this.editor.stopCellEditing()) {
                this.flash();
                return false;
            }
            if (!bl3) {
                if (bl) {
                    this.removeEditor();
                }
                return true;
            }
        }
        if ((object = this.editor.getCellEditorValue()) != null) {
            if (this.cellDataObject != null) {
                try {
                    try {
                        this.cellDataObject = (CellData)this.cellDataObject.getClass().newInstance();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Warning: CellData object lacks no-argument constructor.");
                    }
                    this.cellDataObject.setData(object);
                    object = this.cellDataObject;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    this.cancel();
                    return true;
                }
            }
            if (!this.table.dataView.setCellData(object, this.editRow, this.editColumn) && this.editComponent != null) {
                this.editor.cancelCellEditing();
            }
            if (bl) {
                this.removeEditor();
            }
            return true;
        }
        this.flash();
        this.setFocusOnEditor(this.editComponent);
        return false;
    }

    void commitAndTraverse(int n) {
        JCCellPosition jCCellPosition = null;
        String string = "POINTER";
        switch (n) {
            case 1: {
                string = "LEFT";
                jCCellPosition = InputHandler.findTraversableCell(this.table, string, this.editRow, this.editColumn);
                break;
            }
            case 2: {
                string = "RIGHT";
                jCCellPosition = InputHandler.findTraversableCell(this.table, string, this.editRow, this.editColumn);
                break;
            }
            case 3: {
                string = "UP";
                jCCellPosition = InputHandler.findTraversableCell(this.table, string, this.editRow, this.editColumn);
                break;
            }
            case 4: {
                string = "DOWN";
                jCCellPosition = InputHandler.findTraversableCell(this.table, string, this.editRow, this.editColumn);
                break;
            }
        }
        if (this.commit()) {
            if (jCCellPosition != null) {
                if (this.table.traverseCellListeners != null) {
                    JCTraverseCellEvent jCTraverseCellEvent = new JCTraverseCellEvent(this.table, this.editRow, this.editColumn, jCCellPosition.row, jCCellPosition.column, string);
                    this.table.fireJCTraverseCellEvent(jCTraverseCellEvent);
                    int n2 = jCTraverseCellEvent.next_row;
                    int n3 = jCTraverseCellEvent.next_column;
                    this.traverse(n2, n3, true, null, string, false);
                    return;
                }
                this.traverse(jCCellPosition.row, jCCellPosition.column, true, null, string, false);
                return;
            }
            if (this.clip != null) {
                this.clip.requestFocus();
            }
        }
    }

    void removeEditor() {
        if (this.editComponent != null) {
            this.editComponent.hide();
        }
        this.setCellEditor(null);
        if (this.clip != null) {
            this.clip.requestFocus();
        }
        this.table.paint(new JCCellRange(this.editRow, this.editColumn, this.editRow, this.editColumn));
    }

    public void editingStopped(CellEditorEvent cellEditorEvent) {
        Clip clip;
        if (cellEditorEvent.getEvent() != null && cellEditorEvent.getEvent() instanceof KeyEvent) {
            ((KeyEvent)cellEditorEvent.getEvent()).consume();
        }
        if (this.editor != null && this.table.edit_row == this.editRow && this.table.edit_column == this.editColumn && this.commit(true, false) && (clip = Clip.find(this.table, this.table.edit_row, this.table.edit_column)) != null) {
            clip.requestFocus();
        }
    }

    public void editingCanceled(CellEditorEvent cellEditorEvent) {
        if (this.editor != null && this.table.edit_row == this.editRow && this.table.edit_column == this.editColumn) {
            int n = this.table.edit_row;
            int n2 = this.table.edit_column;
            this.cancel(true);
            Clip clip = Clip.find(this.table, n, n2);
            if (clip != null) {
                clip.requestFocus();
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.tableFocusRequested) {
            return;
        }
        this.tableFocusRequested = true;
        if (focusEvent.getComponent() != this.editComponent) {
            Clip clip = Clip.find_by_type(this.table, 0);
            if (clip != null) {
                clip.requestFocus();
            }
            focusEvent.getComponent().removeFocusListener(this);
        }
        this.tableFocusRequested = false;
    }
}

